{smcl}
{* *! version 1.0.0 26aug2014}{...}
{title:Title}

{phang}
{bf:svarih examples} {hline 2} Generate {cmd:svarih} example estimates


{marker syntax}{...}
{title:Syntax}

{p 8 17 2}
{cmd:svarih} {cmdab:exa:mples} {it:estname} [{cmd:,} {opt s:tore} {opt er:eplace} {opt noi:sily} {opt l:ist} {opt dir:ectory(dir)} {opt clear}]

{marker options_table}{...}
{synoptset 16 tabbed}{...}
{synopthdr}
{synoptline}
{synopt:{opt s:tore}}store example estimates in Stata's estimation catalogue under {it:estname}{p_end}
{synopt:{opt er:eplace}}replace estimation results in {cmd:e()} with {it:estname}{p_end}
{synopt:{opt dir:ectory(dir)}}specify directory where example data set lutkepohl2.dta resides{p_end}
{synopt:{opt noi:sily}}display estimation output when generating example results{p_end}
{synopt:{opt l:ist}}list available example estimates{p_end}
{synopt:{opt clear}}specifies that it is okay to replace the data in memory, even though the current data have not been saved to disk{p_end}
{synoptline}
{p2colreset}{...}

{marker description}{...}
{title:Description}

{pstd}
{cmd:svarih examples} is a small utility that generates {cmd:svarih} example estimates using Stata's example data set lutkepohl2 and stores them in Stata's estimation results catalogue and/or in {cmd:e()}.
It is thought to aide in getting to know the workings of {help svarih} and {help dsimih} commands.
Whenever you find a statement in an examples section of a {cmd:svarih} subcommand help file that stores estimation results under {it:estname}, you can quickly regenerate them using

{pmore}
{cmd:. svarih examples {it:estname} , store}


{marker options}{...}
{title:Options}

{phang}
Options {opt s:tore} and {opt er:eplace} specify where to store the example estimates.
At least one of the two must be specified if {it:estname} is supplied.

{phang2}
{opt s:tore} stores results in Stata's estimation results catalogue.
See {help estimates}.

{phang2}
{opt er:eplace} replaces any existing estimation results in {cmd:e()} with the example estimates.
{cmd:e(sample)} is also set accordingly.

{phang}
{opt dir:ectory(dir)} specifies where to find the file lutkepohl2.dta.
lutkepohl2.dta is used to generate all example estimates.
You can download this file into Stata data set memory by

{pmore}
{cmd:. webuse lutkepohl2}

{pmore}
If you do not want to download this file over and over again, you can save it locally.
By default, {cmd:svarih examples} looks for this file in the current directory.

{pmore}
Use option {opt directory()} if the data set is not already in memory and not in the current working directory.

{phang}
{opt noi:sily} displays the output of the {cmd:svarih} command statement while the example estimation results are being generated.
The default is to generate them {help quietly}.

{phang}
{opt l:ist} lists the example estimates available (the {it:estname}s).

{phang}
{opt clear} specifies that it is okay to replace the data in memory, even though the current data have not been saved to disk.


{marker remarks}{...}
{title:Remarks}

{pstd}
A list of the names of the available example estimates (the {it:estname}s) can be displayed by

{pmore}
{cmd:. svarih examples , list}

{pstd}
{cmd:svarih examples} always uses the data set lutkepohl2.dta to generate example estimates.
{cmd:svarih examples} requires this data set either in memory, in the current working directory, or in {it:dir} of option {opt directory()}.

{pstd}
If the data set lutkepohl2 is already in memory, the {opt store} option accumulates example results if {cmd:svarih examples} is called multiple times.


{marker examples}{...}
{title:Examples}

{phang2}{stata webuse lutkepohl2:. webuse lutkepohl2}{p_end}
{phang2}{stata svarih examples, list:. svarih examples, list}{p_end}
{phang2}{stata svarih examples bac_constr_gls , store:. svarih examples bac_constr_gls , store}{p_end}
{phang2}{stata svarih examples bac_unconstr_gls , store noisily:. svarih examples bac_unconstr_gls , store noisily}{p_end}
{phang2}{stata estimates table bac_constr_gls bac_unconstr_gls:. estimates table bac_constr_gls bac_unconstr_gls}{p_end}
{phang2}{stata estimates restore bac_constr_gls:. estimates restore bac_constr_gls}{p_end}
{phang2}{stata matrix list e(rgmmat):. matrix list e(rgmmat)}{p_end}

{phang2}{stata svarih examples llu_lcns, ereplace:. svarih examples llu_lcns, ereplace}{p_end}
{phang2}{stata dsimih describe , modelstats cmdline:. dsimih describe , modelstats cmdline}{p_end}

{marker author}{...}
{title:Author}

{phang}
Daniel C. Schneider, Goethe University Frankfurt, dan_schneider@outlook.com


{marker alsosee}{...}
{title:Also see}

{psee}
Help:
{helpb svar:[TS] svar},
{helpb svarih bac},
{helpb svarih bfa},
{helpb svarih llu},
{helpb svarih postestimation},
{helpb svarih cmat},
{helpb dsimih}
{p_end}


